(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13023,        341]
NotebookOptionsPosition[     12097,        318]
NotebookOutlinePosition[     12434,        333]
CellTagsIndexPosition[     12391,        330]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.737945063637538*^9, 3.737945071486177*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"1611fd65-5183-4c7e-923a-f072edfe11d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Bin", " ", "space", " ", "and", " ", "time", " ", "and", " ", "average", 
    " ", "the", " ", "stress", " ", "tensor"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"\"\<pars_\>\"", "<>", 
        RowBox[{"ToString", "[", "0", "]"}], "<>", "\"\</Data.h5\>\""}], ",", 
       "\"\</Monolayer/Stress_Full\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "0", ",", "0"}], "}"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{
          RowBox[{"Length", "@", "data"}], "-", "1"}]}], "}"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "345"}], ",", "345", ",", "10"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"data", "=", 
        RowBox[{"Import", "[", 
         RowBox[{
          RowBox[{"\"\<pars_\>\"", "<>", 
           RowBox[{"ToString", "[", "n", "]"}], "<>", "\"\</Data.h5\>\""}], 
          ",", "\"\</Monolayer/Stress_Full\>\""}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"intres", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<X\>\"", ",", "\"\<Stress_XX\>\""}], "}"}], "/.", 
            RowBox[{"data", "[", 
             RowBox[{"[", "t", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"intres", "=", 
           RowBox[{"DeleteCases", "[", 
            RowBox[{"intres", ",", 
             RowBox[{"{", 
              RowBox[{"0.", ",", "0."}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"lists", "=", 
           RowBox[{"BinLists", "[", 
            RowBox[{"intres", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "350"}], ",", "350", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1000"}], ",", "1000", ",", "2000"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"t", ",", ";;", ",", "3"}], "]"}], "]"}], "+=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Total", "@", 
              RowBox[{"list", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", ";;", ",", "2"}], "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"list", ",", "lists"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"t", ",", ";;", ",", "4"}], "]"}], "]"}], "+=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"list", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", ";;", ",", "2"}], "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"list", ",", "lists"}], "}"}]}], "]"}]}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "99"}], "}"}]}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.7416651805557823`*^9, 3.741665240019743*^9}, {
   3.7416653332520847`*^9, 3.7416653360867434`*^9}, {3.743269135249762*^9, 
   3.743269154951325*^9}, {3.743269273088562*^9, 3.743269301535572*^9}, {
   3.743269347304645*^9, 3.7432693510762863`*^9}, {3.743269397082616*^9, 
   3.7432694835480223`*^9}, {3.743269591971575*^9, 3.743269592322155*^9}, {
   3.743269702929749*^9, 3.743269772556604*^9}, {3.74326980936403*^9, 
   3.743269864687022*^9}, {3.7432699498589363`*^9, 3.7432699946642227`*^9}, {
   3.743322582284189*^9, 3.743322607879726*^9}, {3.776534603228492*^9, 
   3.776534606908506*^9}, {3.776534665965044*^9, 3.776534666589449*^9}, 
   3.776534791101481*^9, {3.776534821644313*^9, 3.776534822129718*^9}, {
   3.776534863635684*^9, 3.7765348703434277`*^9}, {3.776534929947246*^9, 
   3.776534952929446*^9}},ExpressionUUID->"0c3f89c9-00e4-45f3-940d-\
2518c8ce38ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "the", " ", "stress", " ", "tensor"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "time"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "x", " ", "position"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "x", " ", "stress"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "cell", " ", "count"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/stress_kymograph.dat\>\"", ",", 
    RowBox[{"Flatten", "[", 
     RowBox[{"result", ",", "1"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.743272885407626*^9, 3.743272906618642*^9}, {
  3.743280802445253*^9, 3.743280803567198*^9}, {3.743308441788683*^9, 
  3.743308443749455*^9}, {3.7765349575118113`*^9, 
  3.776534988780452*^9}},ExpressionUUID->"ac3f0f8e-456a-476f-9617-\
497c1e6e8ebd"],

Cell[BoxData["\<\"~/Downloads/stress_kymograph.dat\"\>"], "Output",
 CellChangeTimes->{3.743272909012918*^9, 3.74328080533858*^9, 
  3.743310879808107*^9, 3.743320641208653*^9, 
  3.74332998050937*^9},ExpressionUUID->"4c8fb06c-3629-4570-ac74-dd7d55b0306f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Bin", " ", "space", " ", "and", " ", "time", " ", "and", " ", "average", 
    " ", "the", " ", "stress", " ", "tensor"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"\"\<pars_\>\"", "<>", 
        RowBox[{"ToString", "[", "0", "]"}], "<>", "\"\</Data.h5\>\""}], ",", 
       "\"\</Monolayer/Stress_Full\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "0", ",", "0"}], "}"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{
          RowBox[{"Length", "@", "data"}], "-", "1"}]}], "}"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "345"}], ",", "345", ",", "10"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"data", "=", 
        RowBox[{"Import", "[", 
         RowBox[{
          RowBox[{"\"\<pars_\>\"", "<>", 
           RowBox[{"ToString", "[", "n", "]"}], "<>", "\"\</Data.h5\>\""}], 
          ",", "\"\<Raw_Data\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"intres", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<Position_X\>\"", ",", "\"\<Velocity_X\>\""}], "}"}],
             "/.", 
            RowBox[{"data", "[", 
             RowBox[{"[", "t", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"intres", "=", 
           RowBox[{"DeleteCases", "[", 
            RowBox[{"intres", ",", 
             RowBox[{"{", 
              RowBox[{"0.", ",", "0."}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"lists", "=", 
           RowBox[{"BinLists", "[", 
            RowBox[{"intres", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "350"}], ",", "350", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1000"}], ",", "1000", ",", "2000"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"t", ",", ";;", ",", "3"}], "]"}], "]"}], "+=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Total", "@", 
              RowBox[{"list", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", ";;", ",", "2"}], "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"list", ",", "lists"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"t", ",", ";;", ",", "4"}], "]"}], "]"}], "+=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"list", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", ";;", ",", "2"}], "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"list", ",", "lists"}], "}"}]}], "]"}]}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"Length", "@", "data"}]}], "}"}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "99"}], "}"}]}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.7432729551151953`*^9, 3.7432729700308123`*^9}, {
  3.7433226209796057`*^9, 3.743322634660589*^9}, {3.7765346093003073`*^9, 
  3.776534612545368*^9}, {3.776534668074057*^9, 3.77653466865487*^9}, {
  3.776534881658128*^9, 3.7765348822686443`*^9}, {3.776534931693488*^9, 
  3.7765349327099743`*^9}, {3.776535011249463*^9, 
  3.7765350120175247`*^9}},ExpressionUUID->"29eaed6c-e06b-4c26-a046-\
848583e7d409"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "the", " ", "stress", " ", "tensor"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "time"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "x", " ", "position"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "x", " ", "velocity"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "cell", " ", "count"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/velocity_kymograph.dat\>\"", ",", 
    RowBox[{"Flatten", "[", 
     RowBox[{"result", ",", "1"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7433084513185377`*^9, 3.743308452683565*^9}, {
  3.776535000692144*^9, 
  3.7765350054732447`*^9}},ExpressionUUID->"2884070a-94aa-4db8-b878-\
9c6822fefebe"],

Cell[BoxData["\<\"~/Downloads/velocity_kymograph.dat\"\>"], "Output",
 CellChangeTimes->{
  3.743352896630404*^9},ExpressionUUID->"840c3f04-4201-4364-812f-\
5e47c82af71c"]
}, Open  ]]
},
WindowSize->{835, 792},
WindowMargins->{{Automatic, 113}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 267, 5, 30, "Input",ExpressionUUID->"1611fd65-5183-4c7e-923a-f072edfe11d3"],
Cell[828, 27, 4641, 113, 346, "Input",ExpressionUUID->"0c3f89c9-00e4-45f3-940d-2518c8ce38ad"],
Cell[CellGroupData[{
Cell[5494, 144, 1014, 24, 136, "Input",ExpressionUUID->"ac3f0f8e-456a-476f-9617-497c1e6e8ebd"],
Cell[6511, 170, 256, 3, 34, "Output",ExpressionUUID->"4c8fb06c-3629-4570-ac74-dd7d55b0306f"]
}, Open  ]],
Cell[6782, 176, 4175, 107, 346, "Input",ExpressionUUID->"29eaed6c-e06b-4c26-a046-848583e7d409"],
Cell[CellGroupData[{
Cell[10982, 287, 925, 23, 136, "Input",ExpressionUUID->"2884070a-94aa-4db8-b878-9c6822fefebe"],
Cell[11910, 312, 171, 3, 34, "Output",ExpressionUUID->"840c3f04-4201-4364-812f-5e47c82af71c"]
}, Open  ]]
}
]
*)

